/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.slf4j.Logger;

public class VanillaPackResources
implements PackResources,
ResourceProvider {
    @Nullable
    public static Path f_10312_;
    private static final Logger f_10315_;
    public static Class<?> f_10313_;
    private static final Map<PackType, Path> f_182296_;
    public final PackMetadataSection f_143759_;
    public final Set<String> f_10314_;

    private static Path m_182297_(URI p_182298_) throws IOException {
        try {
            return Paths.get(p_182298_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            f_10315_.warn("Unable to get path for: {}", (Object)p_182298_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_182298_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_182298_);
    }

    public VanillaPackResources(PackMetadataSection p_143761_, String ... p_143762_) {
        this.f_143759_ = p_143761_;
        this.f_10314_ = ImmutableSet.copyOf((Object[])p_143762_);
    }

    @Override
    public InputStream m_5542_(String p_10358_) throws IOException {
        if (!p_10358_.contains("/") && !p_10358_.contains("\\")) {
            Path path;
            if (f_10312_ != null && Files.exists(path = f_10312_.resolve(p_10358_), new LinkOption[0])) {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            return this.m_5539_(p_10358_);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    @Override
    public InputStream m_8031_(PackType p_10330_, ResourceLocation p_10331_) throws IOException {
        InputStream inputstream = this.m_8033_(p_10330_, p_10331_);
        if (inputstream != null) {
            return inputstream;
        }
        throw new FileNotFoundException(p_10331_.m_135815_());
    }

    @Override
    public Collection<ResourceLocation> m_7466_(PackType p_10324_, String p_10325_, String p_10326_, int p_10327_, Predicate<String> p_10328_) {
        HashSet set = Sets.newHashSet();
        if (f_10312_ != null) {
            try {
                VanillaPackResources.m_10342_(set, p_10327_, p_10325_, f_10312_.resolve(p_10324_.m_10305_()), p_10326_, p_10328_);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (p_10324_ == PackType.CLIENT_RESOURCES) {
                Enumeration<URL> enumeration = null;
                try {
                    enumeration = f_10313_.getClassLoader().getResources(p_10324_.m_10305_() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    try {
                        URI uri = enumeration.nextElement().toURI();
                        if (!"file".equals(uri.getScheme())) continue;
                        VanillaPackResources.m_10342_(set, p_10327_, p_10325_, Paths.get(uri), p_10326_, p_10328_);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            Path path = f_182296_.get(p_10324_);
            if (path != null) {
                VanillaPackResources.m_10342_(set, p_10327_, p_10325_, path, p_10326_, p_10328_);
            } else {
                f_10315_.error("Can't access assets root for type: {}", (Object)p_10324_);
            }
        }
        catch (FileNotFoundException | NoSuchFileException path) {
        }
        catch (IOException ioexception) {
            f_10315_.error("Couldn't get a list of all vanilla resources", (Throwable)ioexception);
        }
        return set;
    }

    private static void m_10342_(Collection<ResourceLocation> p_10343_, int p_10344_, String p_10345_, Path p_10346_, String p_10347_, Predicate<String> p_10348_) throws IOException {
        Path path = p_10346_.resolve(p_10345_);
        try (Stream<Path> stream = Files.walk(path.resolve(p_10347_), p_10344_, new FileVisitOption[0]);){
            stream.filter(p_10353_ -> !p_10353_.endsWith(".mcmeta") && Files.isRegularFile(p_10353_, new LinkOption[0]) && p_10348_.test(p_10353_.getFileName().toString())).map(p_10341_ -> new ResourceLocation(p_10345_, path.relativize((Path)p_10341_).toString().replaceAll("\\\\", "/"))).forEach(p_10343_::add);
        }
    }

    @Nullable
    protected InputStream m_8033_(PackType p_10359_, ResourceLocation p_10360_) {
        Path path;
        String s = VanillaPackResources.m_10362_(p_10359_, p_10360_);
        if (f_10312_ != null && Files.exists(path = f_10312_.resolve(p_10359_.m_10305_() + "/" + p_10360_.m_135827_() + "/" + p_10360_.m_135815_()), new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.m_10335_(s, url) ? this.getExtraInputStream(p_10359_, s) : null;
        }
        catch (IOException ioexception) {
            return VanillaPackResources.class.getResourceAsStream(s);
        }
    }

    private static String m_10362_(PackType p_10363_, ResourceLocation p_10364_) {
        return "/" + p_10363_.m_10305_() + "/" + p_10364_.m_135827_() + "/" + p_10364_.m_135815_();
    }

    private static boolean m_10335_(String p_10336_, @Nullable URL p_10337_) throws IOException {
        return p_10337_ != null && (p_10337_.getProtocol().equals("jar") || FolderPackResources.m_10273_((File)new File(p_10337_.getFile()), (String)p_10336_));
    }

    @Nullable
    protected InputStream m_5539_(String p_10334_) {
        return this.getExtraInputStream(PackType.SERVER_DATA, "/" + p_10334_);
    }

    @Override
    public boolean m_7211_(PackType p_10355_, ResourceLocation p_10356_) {
        Path path;
        String s = VanillaPackResources.m_10362_(p_10355_, p_10356_);
        if (f_10312_ != null && Files.exists(path = f_10312_.resolve(p_10355_.m_10305_() + "/" + p_10356_.m_135827_() + "/" + p_10356_.m_135815_()), new LinkOption[0])) {
            return true;
        }
        try {
            URL url = VanillaPackResources.class.getResource(s);
            return VanillaPackResources.m_10335_(s, url);
        }
        catch (IOException ioexception) {
            return false;
        }
    }

    @Override
    public Set<String> m_5698_(PackType p_10322_) {
        return this.f_10314_;
    }

    @Override
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> p_10333_) throws IOException {
        try {
            T object;
            block9: {
                block8: {
                    try (InputStream inputstream = this.m_5542_("pack.mcmeta");){
                        T t;
                        if (inputstream == null || (t = AbstractPackResources.m_10214_(p_10333_, inputstream)) == null) break block8;
                        object = t;
                        break block9;
                    }
                }
                return (T)(p_10333_ == PackMetadataSection.f_10366_ ? this.f_143759_ : null);
            }
            return object;
        }
        catch (FileNotFoundException | RuntimeException runtimeexception) {
            return (T)(p_10333_ == PackMetadataSection.f_10366_ ? this.f_143759_ : null);
        }
    }

    @Override
    public String m_8017_() {
        return "Default";
    }

    @Override
    public void close() {
    }

    private InputStream getExtraInputStream(PackType type, String resource) {
        try {
            Path rootDir = f_182296_.get(type);
            if (rootDir != null) {
                return Files.newInputStream(rootDir.resolve(resource), new OpenOption[0]);
            }
            return VanillaPackResources.class.getResourceAsStream(resource);
        }
        catch (IOException e) {
            return VanillaPackResources.class.getResourceAsStream(resource);
        }
    }

    public Resource m_142591_(final ResourceLocation p_143764_) throws IOException {
        return new Resource(){
            @Nullable
            InputStream f_143765_;

            public void close() throws IOException {
                if (this.f_143765_ != null) {
                    this.f_143765_.close();
                }
            }

            public ResourceLocation m_7843_() {
                return p_143764_;
            }

            public InputStream m_6679_() {
                try {
                    this.f_143765_ = VanillaPackResources.this.m_8031_(PackType.CLIENT_RESOURCES, p_143764_);
                }
                catch (IOException ioexception) {
                    throw new UncheckedIOException("Could not get client resource from vanilla pack", ioexception);
                }
                return this.f_143765_;
            }

            public boolean m_142564_() {
                return false;
            }

            @Nullable
            public <T> T m_5507_(MetadataSectionSerializer<T> p_143773_) {
                return null;
            }

            public String m_7816_() {
                return p_143764_.toString();
            }
        };
    }

    static {
        f_10315_ = LogUtils.getLogger();
        f_182296_ = (Map)Util.m_137537_(() -> {
            Class<VanillaPackResources> clazz = VanillaPackResources.class;
            synchronized (VanillaPackResources.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (PackType packtype : PackType.values()) {
                    String s = "/" + packtype.m_10305_() + "/.mcassetsroot";
                    URL url = VanillaPackResources.class.getResource(s);
                    if (url == null) {
                        f_10315_.error("File {} does not exist in classpath", (Object)s);
                        continue;
                    }
                    try {
                        URI uri = url.toURI();
                        String s1 = uri.getScheme();
                        if (!"jar".equals(s1) && !"file".equals(s1)) {
                            f_10315_.warn("Assets URL '{}' uses unexpected schema", (Object)uri);
                        }
                        Path path = VanillaPackResources.m_182297_(uri);
                        builder.put((Object)packtype, (Object)path.getParent());
                    }
                    catch (Exception exception) {
                        f_10315_.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
    }
}

